import React, { useState } from "react";
import "./App.css";
import {
  StarPrinter,
  InterfaceType,
  StarDeviceDiscoveryManager,
  StarIO10Logger,
} from "star-io10-web";

function Discovery() {
  const [isProcessing, setIsProcessing] = useState<boolean>(false);
  const [message, setMessage] = useState<string>("");
  async function showMessage(msg: string) {
    console.log(msg);
    setMessage((prev: string) => prev + msg + "\n");
  }

  async function onPressDiscoverButton() {
    showMessage("on press discover button");
    setIsProcessing(true);

    // Start debug log output to console
    // StarIO10Logger.start();

    try {
      const discoveryManager = new StarDeviceDiscoveryManager(
        InterfaceType.Usb,
      );
      discoveryManager.onPrinterFound = async (printer: StarPrinter) => {
        const information = await printer.getInformation();
        showMessage(`
printer found

    identifier: ${printer.connectionSettings.identifier}
    model: ${information.model}
`);
        printer.dispose();
      };

      await discoveryManager.discover();
    } catch (error) {
      showMessage("discovery failed " + error);
      console.error(error);
    } finally {
      // StarIO10Logger.stop();
      setIsProcessing(false);
    }
  }

  return (
    <div className="Discovery">
      {isProcessing && (
        <div className="App-overlay">
          <div className="App-overlay-message">Discovery...</div>
        </div>
      )}
      <div>
        <button id="discover" onClick={onPressDiscoverButton}>
          Discover
        </button>
        <br />
        <div style={{ whiteSpace: "pre-line" }}>
          <p>{message}</p>
        </div>
      </div>
    </div>
  );
}

export default Discovery;
